/***************************************************************************
 *
 * This test program collects raw tach times from the 1st tach channel and
 * prints them on stdout.
 *
 ***************************************************************************/

#include <stdlib.h>		/* For exit */
#include <stdio.h>		/* For printf */
#include "e1432.h"

#define BUF_SIZE	2048

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    int  i, remainder = 0;
    unsigned long buf[BUF_SIZE], tachTimeLast = 0;
    double tachTimes[BUF_SIZE];
    LONGSIZ32 count = 0;
    SHORTSIZ16 laddr = 8;
    SHORTSIZ16 chan_list[2];
    SHORTSIZ16 tachs, tach0;
    E1432ID hw;
    SHORTSIZ16 error;
    float tachFreq;
    double tachTimeOffset = 0.0;
    double tachTimeStep;

    if(e1432_init_io_driver()) {
	(void) fprintf(stderr, "e1432_init_io_driver() failed\n");
       exit(0);
    }

    CHECK(e1432_print_errors(1));

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* create a channel group of the two tach modules */
    tach0 = chan_list[0] = E1432_TACH_CHAN(1);
    chan_list[1] = E1432_TACH_CHAN(2);
    tachs = e1432_create_channel_group(hw, 2, chan_list);
    if (tachs >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group for tachs returned %d\n",
			    					tachs));
	return -1;
    }
   
    /* set the trigger levels of the tach board */
    CHECK(e1432_set_trigger_level(hw, tachs, E1432_TRIGGER_LEVEL_LOWER, 0.5));
    CHECK(e1432_set_trigger_level(hw, tachs, E1432_TRIGGER_LEVEL_UPPER, 0.5));

    /* get the frequency of the tach clock and calculate time step for one
     * step of the raw tach counter 
     */
    CHECK(e1432_get_tach_clock_freq(hw, tachs, &tachFreq));
    tachTimeStep = 1.0 / (double)tachFreq;

    CHECK(e1432_finish_measure(hw, tachs));

    /* Start measurement */
    CHECK(e1432_init_measure(hw, tachs));

    for ( ; ; ) {
	/* get the raw tach times, which are just snap shots at tach crossings
	 * of the 32 bit counter driven by the tach clock.
	 */
	error = e1432_get_raw_tachs(hw, tach0, buf, BUF_SIZE, &count);
	if(error) {
	    (void) printf("e1432_get_raw_tachs returned error = %d\n", error);
	    exit(1);
   	}

	/* convert raw tach times to seconds */
	for(i = 0; i < count; i++)
	{
	    if(buf[i] < tachTimeLast)	/* tach wrap has occured */
	    {
		tachTimeOffset += E1432_TACH_WRAP_COUNT * tachTimeStep;
	    }
	    tachTimeLast = buf[i];
	    tachTimes[i] = tachTimeOffset + (double)buf[i] * tachTimeStep;
	}

	/* print the resulting tach times */
	for(i=0; i < count; )
	{
	    (void) printf("%#-10g   ", tachTimes[i++]);
	    if(((remainder + i)%5) == 0)
		(void) printf("\n");
	}

	remainder = (remainder + count) % 5;
    }
    /*NOTREACHED*/
    return 0;
}

